/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.views;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import technology.rocketjump.undermount.rendering.HexColors;
import technology.rocketjump.undermount.ui.actions.SwitchGuiViewAction;
import technology.rocketjump.undermount.ui.views.GuiView;
import technology.rocketjump.undermount.ui.views.GuiViewName;
import technology.rocketjump.undermount.ui.widgets.ButtonStyle;
import technology.rocketjump.undermount.ui.widgets.IconButton;
import technology.rocketjump.undermount.ui.widgets.IconButtonFactory;

public class DefaultGuiView
implements GuiView {
    List<Actor> buttons = new LinkedList<Actor>();

    @Inject
    public DefaultGuiView(IconButtonFactory iconButtonFactory, MessageDispatcher messageDispatcher) {
        IconButton orders = iconButtonFactory.create("GUI.ORDERS_LABEL", "dig-dug", HexColors.get("#A1D479"), ButtonStyle.DEFAULT);
        orders.setAction(new SwitchGuiViewAction(GuiViewName.ORDER_SELECTION, messageDispatcher));
        this.buttons.add(orders);
        IconButton zones = iconButtonFactory.create("GUI.ZONES_LABEL", "bed", HexColors.get("#C48C7A"), ButtonStyle.DEFAULT);
        zones.setAction(new SwitchGuiViewAction(GuiViewName.ROOM_SELECTION, messageDispatcher));
        this.buttons.add(zones);
    }

    @Override
    public GuiViewName getName() {
        return GuiViewName.DEFAULT_MENU;
    }

    @Override
    public void populate(Table containerTable) {
        for (Actor button : this.buttons) {
            containerTable.add(button).pad(5.0f);
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void onLanguageUpdated() {
    }
}

